/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeApplicationVersionsRequestMarshaller
implements Marshaller<Request<DescribeApplicationVersionsRequest>, DescribeApplicationVersionsRequest> {
    public Request<DescribeApplicationVersionsRequest> marshall(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        SdkInternalList versionLabelsList;
        if (describeApplicationVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationVersionsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeApplicationVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeApplicationVersionsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeApplicationVersionsRequest.getApplicationName()));
        }
        if (!(versionLabelsList = (SdkInternalList)describeApplicationVersionsRequest.getVersionLabels()).isEmpty() || !versionLabelsList.isAutoConstruct()) {
            int versionLabelsListIndex = 1;
            for (String versionLabelsListValue : versionLabelsList) {
                if (versionLabelsListValue != null) {
                    request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
                }
                ++versionLabelsListIndex;
            }
        }
        if (describeApplicationVersionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeApplicationVersionsRequest.getMaxRecords()));
        }
        if (describeApplicationVersionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeApplicationVersionsRequest.getNextToken()));
        }
        return request;
    }
}

