/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.internal.PageBasedCollection;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.util.HashMap;
import java.util.Map;

public abstract class ItemCollection<R>
extends PageBasedCollection<Item, R> {
    private int totalCount;
    private int totalScannedCount;
    private ConsumedCapacity totalConsumedCapacity;

    protected final void accumulateStats(ConsumedCapacity consumedCapacity, Integer count, Integer scannedCount) {
        if (consumedCapacity != null) {
            if (this.totalConsumedCapacity == null) {
                this.totalConsumedCapacity = new ConsumedCapacity();
                this.totalConsumedCapacity.setCapacityUnits(consumedCapacity.getCapacityUnits());
                this.totalConsumedCapacity.setGlobalSecondaryIndexes(this.clone(consumedCapacity.getGlobalSecondaryIndexes()));
                this.totalConsumedCapacity.setLocalSecondaryIndexes(this.clone(consumedCapacity.getLocalSecondaryIndexes()));
                this.totalConsumedCapacity.setTable(this.clone(consumedCapacity.getTable()));
                this.totalConsumedCapacity.setTableName(consumedCapacity.getTableName());
            } else {
                Double capunit = this.totalConsumedCapacity.getCapacityUnits();
                Double delta = consumedCapacity.getCapacityUnits();
                if (capunit == null) {
                    this.totalConsumedCapacity.setCapacityUnits(delta);
                } else {
                    this.totalConsumedCapacity.setCapacityUnits(capunit + (delta == null ? 0.0 : delta));
                }
                Map<String, Capacity> gsi = this.totalConsumedCapacity.getGlobalSecondaryIndexes();
                if (gsi == null) {
                    this.totalConsumedCapacity.setGlobalSecondaryIndexes(this.clone(consumedCapacity.getGlobalSecondaryIndexes()));
                } else {
                    this.totalConsumedCapacity.setGlobalSecondaryIndexes(this.add(consumedCapacity.getGlobalSecondaryIndexes(), this.totalConsumedCapacity.getGlobalSecondaryIndexes()));
                }
                Map<String, Capacity> lsi = this.totalConsumedCapacity.getLocalSecondaryIndexes();
                if (lsi == null) {
                    this.totalConsumedCapacity.setLocalSecondaryIndexes(this.clone(consumedCapacity.getLocalSecondaryIndexes()));
                } else {
                    this.totalConsumedCapacity.setLocalSecondaryIndexes(this.add(consumedCapacity.getLocalSecondaryIndexes(), this.totalConsumedCapacity.getLocalSecondaryIndexes()));
                }
            }
        }
        if (count != null) {
            this.totalCount += count.intValue();
        }
        if (scannedCount != null) {
            this.totalScannedCount += scannedCount.intValue();
        }
    }

    private Map<String, Capacity> add(Map<String, Capacity> from, Map<String, Capacity> to) {
        if (to == null) {
            return this.clone(from);
        }
        if (from != null) {
            for (Map.Entry<String, Capacity> entryFrom : from.entrySet()) {
                String key = entryFrom.getKey();
                Capacity tocap = to.get(key);
                Capacity fromcap = entryFrom.getValue();
                if (tocap == null) {
                    to.put(key, this.clone(fromcap));
                    continue;
                }
                to.put(key, new Capacity().withCapacityUnits(this.doubleOf(tocap) + this.doubleOf(fromcap)));
            }
        }
        return to;
    }

    private Map<String, Capacity> clone(Map<String, Capacity> capacityMap) {
        if (capacityMap == null) {
            return null;
        }
        HashMap<String, Capacity> clone = new HashMap<String, Capacity>(capacityMap.size());
        for (Map.Entry<String, Capacity> e : capacityMap.entrySet()) {
            clone.put(e.getKey(), this.clone(e.getValue()));
        }
        return clone;
    }

    private Capacity clone(Capacity capacity) {
        return capacity == null ? null : new Capacity().withCapacityUnits(capacity.getCapacityUnits());
    }

    private double doubleOf(Capacity cap) {
        if (cap == null) {
            return 0.0;
        }
        Double val = cap.getCapacityUnits();
        return val == null ? 0.0 : val;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalScannedCount() {
        return this.totalScannedCount;
    }

    public ConsumedCapacity getTotalConsumedCapacity() {
        return this.totalConsumedCapacity;
    }
}

