/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarnotifications.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codestarnotifications.model.ListTargetsFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<ListTargetsFilter> filters;
    private String nextToken;
    private Integer maxResults;

    public List<ListTargetsFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ListTargetsFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<ListTargetsFilter>(filters);
    }

    public ListTargetsRequest withFilters(ListTargetsFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<ListTargetsFilter>(filters.length));
        }
        for (ListTargetsFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListTargetsRequest withFilters(Collection<ListTargetsFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTargetsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListTargetsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsRequest)) {
            return false;
        }
        ListTargetsRequest other = (ListTargetsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListTargetsRequest clone() {
        return (ListTargetsRequest)super.clone();
    }
}

