/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.transform.LaunchGroupMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LaunchGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private Map<String, String> featureVariations;
    private String name;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public LaunchGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getFeatureVariations() {
        return this.featureVariations;
    }

    public void setFeatureVariations(Map<String, String> featureVariations) {
        this.featureVariations = featureVariations;
    }

    public LaunchGroup withFeatureVariations(Map<String, String> featureVariations) {
        this.setFeatureVariations(featureVariations);
        return this;
    }

    public LaunchGroup addFeatureVariationsEntry(String key, String value) {
        if (null == this.featureVariations) {
            this.featureVariations = new HashMap<String, String>();
        }
        if (this.featureVariations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.featureVariations.put(key, value);
        return this;
    }

    public LaunchGroup clearFeatureVariationsEntries() {
        this.featureVariations = null;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LaunchGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFeatureVariations() != null) {
            sb.append("FeatureVariations: ").append(this.getFeatureVariations()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchGroup)) {
            return false;
        }
        LaunchGroup other = (LaunchGroup)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFeatureVariations() == null ^ this.getFeatureVariations() == null) {
            return false;
        }
        if (other.getFeatureVariations() != null && !other.getFeatureVariations().equals(this.getFeatureVariations())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureVariations() == null ? 0 : this.getFeatureVariations().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public LaunchGroup clone() {
        try {
            return (LaunchGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

