/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMembershipResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The membership retrieved for the provided identifier.
     * </p>
     */
    private Membership membership;

    /**
     * <p>
     * The membership retrieved for the provided identifier.
     * </p>
     * 
     * @param membership
     *        The membership retrieved for the provided identifier.
     */

    public void setMembership(Membership membership) {
        this.membership = membership;
    }

    /**
     * <p>
     * The membership retrieved for the provided identifier.
     * </p>
     * 
     * @return The membership retrieved for the provided identifier.
     */

    public Membership getMembership() {
        return this.membership;
    }

    /**
     * <p>
     * The membership retrieved for the provided identifier.
     * </p>
     * 
     * @param membership
     *        The membership retrieved for the provided identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMembershipResult withMembership(Membership membership) {
        setMembership(membership);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMembership() != null)
            sb.append("Membership: ").append(getMembership());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMembershipResult == false)
            return false;
        GetMembershipResult other = (GetMembershipResult) obj;
        if (other.getMembership() == null ^ this.getMembership() == null)
            return false;
        if (other.getMembership() != null && other.getMembership().equals(this.getMembership()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMembership() == null) ? 0 : getMembership().hashCode());
        return hashCode;
    }

    @Override
    public GetMembershipResult clone() {
        try {
            return (GetMembershipResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
