/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.services.apptest.model.CloudFormation;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class CloudFormationJsonUnmarshaller
implements Unmarshaller<CloudFormation, JsonUnmarshallerContext> {
    private static CloudFormationJsonUnmarshaller instance;

    public CloudFormation unmarshall(JsonUnmarshallerContext context) throws Exception {
        CloudFormation cloudFormation = new CloudFormation();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("templateLocation", targetDepth)) {
                    context.nextToken();
                    cloudFormation.setTemplateLocation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("parameters", targetDepth)) {
                    context.nextToken();
                    cloudFormation.setParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return cloudFormation;
    }

    public static CloudFormationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CloudFormationJsonUnmarshaller();
        }
        return instance;
    }
}

