/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.lwa.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(builder=Builder.class)
public class AccessTokenResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="token_type")
    private String tokenType;

    private AccessTokenResponse(Builder builder) {
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
        this.scope = builder.scope;
        this.tokenType = builder.tokenType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public static class Builder {
        private String accessToken;
        private long expiresIn;
        private String scope;
        private String tokenType;

        @JsonProperty(value="access_token")
        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @JsonProperty(value="expires_in")
        public Builder withExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @JsonProperty(value="scope")
        public Builder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="token_type")
        public Builder withTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public AccessTokenResponse build() {
            return new AccessTokenResponse(this);
        }
    }
}

