/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class AsyncSearchResponseBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    private final String expirationTimeInMillis;
    private final String startTimeInMillis;

    protected AsyncSearchResponseBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.isPartial = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).isPartial, this, "isPartial");
        this.isRunning = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).isRunning, this, "isRunning");
        this.expirationTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).expirationTimeInMillis, this, "expirationTimeInMillis");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).startTimeInMillis, this, "startTimeInMillis");
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final String expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    public final String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        generator.writeKey("expiration_time_in_millis");
        generator.write(this.expirationTimeInMillis);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAsyncSearchResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(AbstractBuilder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(AbstractBuilder::expirationTimeInMillis, JsonpDeserializer.stringDeserializer(), "expiration_time_in_millis");
        op.add(AbstractBuilder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        private String expirationTimeInMillis;
        private String startTimeInMillis;

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isPartial(boolean value) {
            this.isPartial = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isRunning(boolean value) {
            this.isRunning = value;
            return (BuilderT)this.self();
        }

        public final BuilderT expirationTimeInMillis(String value) {
            this.expirationTimeInMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT startTimeInMillis(String value) {
            this.startTimeInMillis = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

