/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TermVectorOption;
import co.elastic.clients.elasticsearch._types.mapping.TextIndexPrefixes;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DynamicProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final FieldValue nullValue;
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Script script;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final Boolean indexPhrases;
    @Nullable
    private final TextIndexPrefixes indexPrefixes;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final Integer positionIncrementGap;
    @Nullable
    private final String searchAnalyzer;
    @Nullable
    private final String searchQuoteAnalyzer;
    @Nullable
    private final TermVectorOption termVector;
    @Nullable
    private final String format;
    @Nullable
    private final Integer precisionStep;
    @Nullable
    private final String locale;
    public static final JsonpDeserializer<DynamicProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DynamicProperty::setupDynamicPropertyDeserializer);

    private DynamicProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.nullValue = builder.nullValue;
        this.boost = builder.boost;
        this.coerce = builder.coerce;
        this.script = builder.script;
        this.onScriptError = builder.onScriptError;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.analyzer = builder.analyzer;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.indexPhrases = builder.indexPhrases;
        this.indexPrefixes = builder.indexPrefixes;
        this.norms = builder.norms;
        this.positionIncrementGap = builder.positionIncrementGap;
        this.searchAnalyzer = builder.searchAnalyzer;
        this.searchQuoteAnalyzer = builder.searchQuoteAnalyzer;
        this.termVector = builder.termVector;
        this.format = builder.format;
        this.precisionStep = builder.precisionStep;
        this.locale = builder.locale;
    }

    public static DynamicProperty of(Function<Builder, ObjectBuilder<DynamicProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DynamicProperty;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final FieldValue nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final Boolean indexPhrases() {
        return this.indexPhrases;
    }

    @Nullable
    public final TextIndexPrefixes indexPrefixes() {
        return this.indexPrefixes;
    }

    @Nullable
    public final Boolean norms() {
        return this.norms;
    }

    @Nullable
    public final Integer positionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Nullable
    public final String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Nullable
    public final String searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Nullable
    public final TermVectorOption termVector() {
        return this.termVector;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Integer precisionStep() {
        return this.precisionStep;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "{dynamic_type}");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            this.nullValue.serialize(generator, mapper);
        }
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.indexPhrases != null) {
            generator.writeKey("index_phrases");
            generator.write(this.indexPhrases.booleanValue());
        }
        if (this.indexPrefixes != null) {
            generator.writeKey("index_prefixes");
            this.indexPrefixes.serialize(generator, mapper);
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms.booleanValue());
        }
        if (this.positionIncrementGap != null) {
            generator.writeKey("position_increment_gap");
            generator.write(this.positionIncrementGap.intValue());
        }
        if (this.searchAnalyzer != null) {
            generator.writeKey("search_analyzer");
            generator.write(this.searchAnalyzer);
        }
        if (this.searchQuoteAnalyzer != null) {
            generator.writeKey("search_quote_analyzer");
            generator.write(this.searchQuoteAnalyzer);
        }
        if (this.termVector != null) {
            generator.writeKey("term_vector");
            this.termVector.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.precisionStep != null) {
            generator.writeKey("precision_step");
            generator.write(this.precisionStep.intValue());
        }
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
    }

    protected static void setupDynamicPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::nullValue, FieldValue._DESERIALIZER, "null_value");
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::indexPhrases, JsonpDeserializer.booleanDeserializer(), "index_phrases");
        op.add(Builder::indexPrefixes, TextIndexPrefixes._DESERIALIZER, "index_prefixes");
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms");
        op.add(Builder::positionIncrementGap, JsonpDeserializer.integerDeserializer(), "position_increment_gap");
        op.add(Builder::searchAnalyzer, JsonpDeserializer.stringDeserializer(), "search_analyzer");
        op.add(Builder::searchQuoteAnalyzer, JsonpDeserializer.stringDeserializer(), "search_quote_analyzer");
        op.add(Builder::termVector, TermVectorOption._DESERIALIZER, "term_vector");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::precisionStep, JsonpDeserializer.integerDeserializer(), "precision_step");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DynamicProperty> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private FieldValue nullValue;
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private Script script;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private Boolean indexPhrases;
        @Nullable
        private TextIndexPrefixes indexPrefixes;
        @Nullable
        private Boolean norms;
        @Nullable
        private Integer positionIncrementGap;
        @Nullable
        private String searchAnalyzer;
        @Nullable
        private String searchQuoteAnalyzer;
        @Nullable
        private TermVectorOption termVector;
        @Nullable
        private String format;
        @Nullable
        private Integer precisionStep;
        @Nullable
        private String locale;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder nullValue(@Nullable FieldValue value) {
            this.nullValue = value;
            return this;
        }

        public final Builder nullValue(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.nullValue(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder nullValue(String value) {
            this.nullValue = FieldValue.of(value);
            return this;
        }

        public final Builder nullValue(long value) {
            this.nullValue = FieldValue.of(value);
            return this;
        }

        public final Builder nullValue(double value) {
            this.nullValue = FieldValue.of(value);
            return this;
        }

        public final Builder nullValue(boolean value) {
            this.nullValue = FieldValue.of(value);
            return this;
        }

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder indexPhrases(@Nullable Boolean value) {
            this.indexPhrases = value;
            return this;
        }

        public final Builder indexPrefixes(@Nullable TextIndexPrefixes value) {
            this.indexPrefixes = value;
            return this;
        }

        public final Builder indexPrefixes(Function<TextIndexPrefixes.Builder, ObjectBuilder<TextIndexPrefixes>> fn) {
            return this.indexPrefixes(fn.apply(new TextIndexPrefixes.Builder()).build());
        }

        public final Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public final Builder positionIncrementGap(@Nullable Integer value) {
            this.positionIncrementGap = value;
            return this;
        }

        public final Builder searchAnalyzer(@Nullable String value) {
            this.searchAnalyzer = value;
            return this;
        }

        public final Builder searchQuoteAnalyzer(@Nullable String value) {
            this.searchQuoteAnalyzer = value;
            return this;
        }

        public final Builder termVector(@Nullable TermVectorOption value) {
            this.termVector = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder precisionStep(@Nullable Integer value) {
            this.precisionStep = value;
            return this;
        }

        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DynamicProperty build() {
            this._checkSingleUse();
            return new DynamicProperty(this);
        }
    }
}

